const Users = require('../models/UserModel');

exports.getAccessibleUserIds = async (currentUserId) => {
    const me = await Users.findByPk(currentUserId);

    if (!me) return [];

    // Kalau dia sub-account → hanya boleh lihat dirinya sendiri
    if (me.parent_user_id) {
        return [me.id];
    }

    // Kalau dia main account → ambil semua sub-account aktif
    const subs = await Users.findAll({
        where: {
            parent_user_id: me.id,
            is_active: true
        },
        attributes: ['id']
    });

    const subIds = subs.map(u => u.id);

    return [me.id, ...subIds];
};

exports.isMainAccount = async (currentUserId) => {
    const me = await Users.findByPk(currentUserId);
    if (!me) return false;
    return me.parent_user_id === null && me.role === 'MAIN';
};
