const express = require('express');
const {
    createTransfer,
    getTransfers,
    updateTransfer,
    deleteTransfer
} = require('../controllers/TransferController');
const { verifyToken } = require('../middleware/VerifyToken');

const router = express.Router();

router.get('/transfers', verifyToken, getTransfers);
router.post('/transfers', verifyToken, createTransfer);
router.patch('/transfers/:id', verifyToken, updateTransfer);
router.delete('/transfers/:id', verifyToken, deleteTransfer);

module.exports = router;
