const express = require('express');
// kalau file nyata bernama TransactionsController.js
const {
  getTransactions,
  createTransaction,
  updateTransaction,
  deleteTransaction,
  getIncomeReport
} = require('../controllers/TransactionsController');
const { verifyToken } = require('../middleware/VerifyToken');

const router = express.Router();

router.get('/transactions', verifyToken, getTransactions);
router.post('/transactions', verifyToken, createTransaction);
router.patch('/transactions/:id', verifyToken, updateTransaction);
router.delete('/transactions/:id', verifyToken, deleteTransaction);

// LAPORAN TRANSAKSI MASUK (INCOME ONLY)
router.get('/reports/income', verifyToken, getIncomeReport);

module.exports = router;
