const express = require('express');
const {
    createSavingGoal,
    getSavingGoals,
    getSavingGoalDetail,
    updateSavingGoal,
    deleteSavingGoal,
    createSavingTransaction,
    updateSavingTransaction,
    deleteSavingTransaction,
    getSavingTransactionsByGoal
} = require('../controllers/SavingGoalController');
const { verifyToken } = require('../middleware/VerifyToken');

const router = express.Router();

// Target tabungan
router.post('/saving-goals', verifyToken, createSavingGoal);
router.get('/saving-goals', verifyToken, getSavingGoals);
router.get('/saving-goals/:id', verifyToken, getSavingGoalDetail);
router.patch('/saving-goals/:id', verifyToken, updateSavingGoal);
router.delete('/saving-goals/:id', verifyToken, deleteSavingGoal);

// Transaksi tabungan (nabung / tarik)
router.post('/saving-goals/transactions', verifyToken, createSavingTransaction);
router.patch('/saving-goals/transactions/:id', verifyToken, updateSavingTransaction);
router.delete('/saving-goals/transactions/:id', verifyToken, deleteSavingTransaction);
router.get('/saving-goals/:id/transactions', verifyToken, getSavingTransactionsByGoal);

module.exports = router;
