const { DataTypes } = require('sequelize');
const db = require('../config/database');
const Users = require('./UserModel');
const Accounts = require('./AccountModel');

const Transfers = db.define('transfers', {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true
    },
    user_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    from_account_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    to_account_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    amount: {
        type: DataTypes.DECIMAL(18, 2),
        allowNull: false
    },
    description: {
        type: DataTypes.STRING,
        allowNull: true
    },
    date: {
        type: DataTypes.DATEONLY,
        allowNull: false
    }
}, {
    freezeTableName: true
});

// Relasi
Users.hasMany(Transfers, { foreignKey: 'user_id' });
Transfers.belongsTo(Users, { foreignKey: 'user_id' });

Accounts.hasMany(Transfers, { as: 'OutgoingTransfers', foreignKey: 'from_account_id' });
Accounts.hasMany(Transfers, { as: 'IncomingTransfers', foreignKey: 'to_account_id' });

Transfers.belongsTo(Accounts, { as: 'from_account', foreignKey: 'from_account_id' });
Transfers.belongsTo(Accounts, { as: 'to_account', foreignKey: 'to_account_id' });

module.exports = Transfers;
