const { DataTypes } = require('sequelize');
const db = require('../config/database');
const Users = require('./UserModel');
const Accounts = require('./AccountModel');

const SavingGoal = db.define('saving_goals', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    user_id: {
        type: DataTypes.INTEGER,
        allowNull: false
    },
    account_id: {
        // akun utama tempat tabungan ditaruh (opsional)
        type: DataTypes.INTEGER,
        allowNull: true
    },
    name: {
        type: DataTypes.STRING,
        allowNull: false
    },
    description: {
        type: DataTypes.STRING,
        allowNull: true
    },
    target_amount: {
        type: DataTypes.DECIMAL(15, 2),
        allowNull: false
    },
    current_amount: {
        type: DataTypes.DECIMAL(15, 2),
        allowNull: false,
        defaultValue: 0
    },
    total_months: {
        // berapa bulan target dicapai
        type: DataTypes.INTEGER,
        allowNull: false
    },
    start_date: {
        type: DataTypes.DATEONLY,
        allowNull: false
    },
    status: {
        type: DataTypes.ENUM('ONGOING', 'ACHIEVED', 'CANCELLED'),
        allowNull: false,
        defaultValue: 'ONGOING'
    }
}, {
    freezeTableName: true
});

SavingGoal.belongsTo(Users, { foreignKey: 'user_id' });
SavingGoal.belongsTo(Accounts, { foreignKey: 'account_id' });

module.exports = SavingGoal;
