const { DataTypes } = require('sequelize');
const db = require('../config/database');
const Users = require('./UserModel');

const Accounts = db.define('accounts', {
    id: {
        type : DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    name: {
        type: DataTypes.STRING,
        allowNull: false
    },
    type: {
        type: DataTypes.ENUM('CASH', 'BANK', 'CREDIT_CARD', 'E_WALLET'),
        defaultValue: 'CASH'
    },
    balance: {
        type: DataTypes.DECIMAL(15,2),
        defaultValue: 0
    },
    credit_limit: {
        type: DataTypes.DECIMAL(15,2),
        defaultValue: 0,
        comment: 'Hanya diisi jika type adalah CREDIT_CARD'
    },
    user_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Users,
            key: 'id'
        }
    }
}, {
    freezeTableName: true
});

Users.hasMany(Accounts, {foreignKey: 'user_id'});
Accounts.belongsTo(Users,{foreignKey: 'user_id'});

module.exports = Accounts;